{ Install utility for MS Excel Add-Ins }
{ Copyright (c) Edgar Goettel 2008 - 2013 }
{ - check routines - }
unit InstCheck;
// Does not check the intallation but the number of running instances ;-)
// and provides a check whether Excel is running or not

interface

function MultiInstance: boolean;
function ExcelIsRunning: boolean;

implementation

uses
 Windows, ActiveX;

var
  mHandle: THandle;
  iCheck: Boolean;

function MultiInstance: boolean;
begin
  Result:= iCheck;
end;

function ExcelIsRunning: boolean;
var
  app: WideString;
  classid: TCLSID;
  unknown: IUnknown;
  hr: HRESULT;
begin
  CoInitialize(nil);
  app:= 'Excel.Application';
  if CLSIDFromProgID(PWideChar(app), classid) = S_OK then begin
    hr:= GetActiveObject(classid, nil, unknown);
    unknown:= nil;
    Result:= hr = S_OK;
  end else
    Result:= False;
  CoUnInitialize;
end;

initialization
  mHandle:= CreateMutex(nil, True, 'AddInInst');
  if GetLastError = ERROR_ALREADY_EXISTS then
    iCheck:= True
  else
    iCheck:= False; // keine weitere instanz am laufen
finalization
  if mHandle <> 0 then
    CloseHandle(mHandle);
end.